#extension GL_EXT_draw_buffers : enable

precision mediump float;

uniform sampler2D texture_emissive;
uniform vec4  colour_emissive;

varying vec4 v_colour;
varying vec3 v_normal;
varying vec2 v_uv;

void main()
{
    // Fetch Fragments Normal + Diffuse textures    
    vec4 emissive = texture2D( texture_emissive, v_uv);
    vec4 diffuse  = vec4(0.0,0.0,0.0,0.5);

    // Pick whether to use the emissive colour or the diffuse
    // colour_emissive.w = 1.0h  ... use colour_emissive
    // colour_emissive_w = 0.0h  ... use diffuse
    vec4 diffuseCol  = (diffuse*(1.0-colour_emissive.w)) + (colour_emissive*colour_emissive.w);
    diffuseCol = mix(diffuse,diffuseCol,emissive.r);
    diffuseCol.a = 0.5;
        
    // Pack vertex normal
    vec4 normal = vec4((v_normal.xyz+1.0)*0.5,0.25);
    
    // Write to albedo+normal buffers    
    gl_FragData[0] = diffuseCol;
    gl_FragData[1] = normal;
}
